/* 
 * En gros, deux manières d'écrire la classe abstraite Expression :
 * - soit en y mettant tout les méthodes utiles pour Nombre et Operation,
 *   à savoir ajouter, supprimer, getChild, etc, et y mettre un comportement
 *   par défault malin, comme lancer une exception.
 * - soit ne mettre dans Expression que ce qui est en commun entre Nombre et 
 *   Operation, et représenter votre arbre par une variable de type Operation
 *   plutôt que Expression.
 * Disons que l'on part sur cette première manière de faire.
 */

import java.util.ArrayList;

abstract class Expression
{
  public void ajouter( Expression e )
  {
    throw new UnsupportedOperationException();
  }

  public void supprimer( Expression e )
  {
    throw new UnsupportedOperationException();
  }

  public ArrayList<Expression> getChildren()
  {
    throw new UnsupportedOperationException();
  }

  public int getN()
  {
    throw new UnsupportedOperationException();
  }

  public abstract int accepter( Visitor v );
}

class Nombre extends Expression
{
  private int n_;

  public Nombre( int n )
  {
    n_ = n;
  }
  
  public int getN()
  {
    return n_;
  }

  public int accepter( Visitor v )
  {
    return v.visiter( this );
  }
}

abstract class Operation extends Expression
{
  protected ArrayList<Expression> children;

  public Operation()
  {
    children = new ArrayList<Expression>();
  }

  public void ajouter( Expression e )
  {
    children.add( e );
  }

  public void supprimer( Expression e )
  {
    children.remove( e );
  }

  public ArrayList<Expression> getChildren()
  {
    return children;
  }
}

class Plus extends Operation
{
  public int accepter( Visitor v )
  {
    return v.visiter( this );
  }
}

class Moins extends Operation
{
  public int accepter( Visitor v )
  {
    return v.visiter( this );
  }
}

